$TITLE: 26 COUNTRIE INSIDE MONEY STRUCTURE: BY CHUNDING LI
OPTION NLP=CONOPT

SET
R    COUNTRIES    /AUSTRALIA,BAHRAIN,BRAZIL,BRUNEI,CANADA,CHILE,CHINA,EU,INDIA,INDONESIA,JAPAN,KOREA,
                   KUWAIT,MALAYSIA,MEXICO,NEWZEALAND,PERU,PHILIPPINE,QATAR,RUSSIAN,ARABIA,SINGAPORE,
                   THAILAND,US,VIETNAM,ROW/
G    SECTORS      /TRADABLE, NONTRADABLE/
F    FACTORS      /K,L/
;
ALIAS (R,RR),(R,RRR),(G,GG),(F,FF);

PARAMETERS
PRN1(R,G)         TOTAL PRODUCTION
FACDEM1(R,G,F)    FACTOR DEMAND IN PRODUCTION
ELASP0(R,G)       FACTOR ELASTICITY OF SUBSTITUTION

TGDEM1(R)         ARMINGTON TRADABLE COMPOSITE GOODS DEMAND
/AUSTRALIA           364.1
 BAHRAIN             25.8
 BRAZIL              367.4
 BRUNEI              6.3
 CANADA              763.6
 CHILE               98.9
 CHINA               6159
 EU                  4376.6
 INDIA               1307.9
 INDONESIA           555.7
 JAPAN               1516.3
 KOREA               731.2
 KUWAIT              48.4
 MALAYSIA            234.3
 MEXICO              632.3
 NEWZEALAND          66.8
 PERU                80.5
 PHILIPPINE          180.0
 QATAR               64.7
 RUSSIAN             372.2
 ARABIA              247.3
 SINGAPORE           380.6
 THAILAND            284.3
 US                  4870
 VIETNAM             303.1
 ROW                 8205.0/,
GDEM1(R,RR)       TRADABLE GOODS DEMAND
NGDEM1(R)         NONTRADABLE GOODS DEMAND
/AUSTRALIA           971.9
 BAHRAIN             10.1
 BRAZIL              1391.6
 BRUNEI              2.3
 CANADA              868.3
 CHILE               171.6
 CHINA               6738.8
 EU                  13946.6
 INDIA               1521.0
 INDONESIA           428.3
 JAPAN               3281.5
 KOREA               783.0
 KUWAIT              43.1
 MALAYSIA            66.9
 MEXICO              490.7
 NEWZEALAND          121.8
 PERU                112.3
 PHILIPPINE          144.9
 QATAR               62.5
 RUSSIAN             1015.7
 ARABIA              342.3
 SINGAPORE           174.9
 THAILAND            197.7
 US                  16160.7
 VIETNAM             71.7
 ROW                 1508.3/,

MONEY1(R)         INSIDE MONEY
/AUSTRALIA           1017.3
 BAHRAIN             993.7
 BRAZIL              1058.7
 BRUNEI              1002.4
 CANADA              990.5
 CHILE               1001.3
 CHINA               1359.3
 EU                  973.1
 INDIA               814.9
 INDONESIA           991.5
 JAPAN               990.0
 KOREA               1069.6
 KUWAIT              1036
 MALAYSIA            1029.9
 MEXICO              986.4
 NEWZEALAND          996.1
 PERU                1004.8
 PHILIPPINE          952.4
 QATAR               1052.6
 RUSSIAN             1211.3
 ARABIA              1159.3
 SINGAPORE           1041.2
 THAILAND            1003.3
 US                  53.9
 VIETNAM             1006.8
 ROW                 1203.7/,

ELASC10(R)         ELASTICITY OF ARMINGTON CONSUMPTION
/AUSTRALIA           1.0
 BAHRAIN             1.0
 BRAZIL              1.0
 BRUNEI              1.0
 CANADA              1.0
 CHILE               1.0
 CHINA               1.0
 EU                  1.0
 INDIA               1.0
 INDONESIA           1.0
 JAPAN               1.0
 KOREA               1.0
 KUWAIT              1.0
 MALAYSIA            1.0
 MEXICO              1.0
 NEWZEALAND          1.0
 PERU                1.0
 PHILIPPINE          1.0
 QATAR               1.0
 RUSSIAN             1.0
 ARABIA              1.0
 SINGAPORE           1.0
 THAILAND            1.0
 US                  1.0
 VIETNAM             1.0
 ROW                 1.0/,

ELASC20(R)         ELASTICITY OF GOODS CONSUMPTION
/AUSTRALIA           1.0
 BAHRAIN             1.0
 BRAZIL              1.0
 BRUNEI              1.0
 CANADA              1.0
 CHILE               1.0
 CHINA               1.0
 EU                  1.0
 INDIA               1.0
 INDONESIA           1.0
 JAPAN               1.0
 KOREA               1.0
 KUWAIT              1.0
 MALAYSIA            1.0
 MEXICO              1.0
 NEWZEALAND          1.0
 PERU                1.0
 PHILIPPINE          1.0
 QATAR               1.0
 RUSSIAN             1.0
 ARABIA              1.0
 SINGAPORE           1.0
 THAILAND            1.0
 US                  1.0
 VIETNAM             1.0
 ROW                 1.0/,

ENDW(R,F)         ENDOWMENT OF FACTORS BY INDIVIDUAL
TARIFF(R,RR)      IMPORT TARIFF
NTARIFF(R,RR)     NON-TARIFF BARRIER
RTA(R,RR)         PARAMETER OF TARIFF USED FOR CALCULATING FTA CHANGE
FTA(R,RR)         JOINT FTA EFFECT
WAR(R,RR)         CHINA-US TRADE WAR
;

TABLE PRN1(R,G)
                    TRADABLE          NONTRADABLE
AUSTRALIA           381.4             1052.5
BAHRAIN             19.5              18.2
BRAZIL              426.1             1442.5
BRUNEI              8.7               4.9
CANADA              754.1             959.2
CHILE               100.2             198.0
CHINA               6518.3            7089.9
EU                  4349.7            14398.9
INDIA               1122.8            1595.9
INDONESIA           547.2             495
JAPAN               1506.3            3465
KOREA               800.8             818.6
KUWAIT              84.4              56.2
MALAYSIA            264.2             94.4
MEXICO              618.7             602.0
NEWZEALAND          62.9              142.0
PERU                85.3              136.8
PHILIPPINE          132.4             198.5
QATAR               117.3             74.1
RUSSIAN             583.5             1074.1
ARABIA              406.6             379.9
SINGAPORE           421.8             242.4
THAILAND            287.6             217.3
US                  3923.9            16620.4
VIETNAM             309.9             115.3
ROW                 8408.7            2655.4  ;

TABLE FACDEM1(R,G,F)
                                     K                L
AUSTRALIA.TRADABLE                   91.5             289.9
AUSTRALIA.NONTRADABLE                252.6            799.9
BAHRAIN.TRADABLE                     6.3              13.2
BAHRAIN.NONTRADABLE                  5.8              12.4
BRAZIL.TRADABLE                      63.9             362.2
BRAZIL.NONTRADABLE                   216.4            1226.1
BRUNEI.TRADABLE                      3.5              5.2
BRUNEI.NONTRADABLE                   2.1              2.8
CANADA.TRADABLE                      173.5            580.6
CANADA.NONTRADABLE                   220.6            738.6
CHILE.TRADABLE                       23.1             77.1
CHILE.NONTRADABLE                    45.5             152.5
CHINA.TRADABLE                       2868             3650.3
CHINA.NONTRADABLE                    3119.6           3970.3
EU.TRADABLE                          913.4            3436.3
EU.NONTRADABLE                       3023.8           11375.1
INDIA.TRADABLE                       348.1            774.7
INDIA.NONTRADABLE                    494.7            1101.2
INDONESIA.TRADABLE                   191.5            355.7
INDONESIA.NONTRADABLE                173.3            321.7
JAPAN.TRADABLE                       361.5            1144.8
JAPAN.NONTRADABLE                    831.6            2633.4
KOREA.TRADABLE                       240.2            560.6
KOREA.NONTRADABLE                    245.6            573
KUWAIT.TRADABLE                      21.1             63.3
KUWAIT.NONTRADABLE                   14.1             42.1
MALAYSIA.TRADABLE                    63.4             200.8
MALAYSIA.NONTRADABLE                 22.7             71.7
MEXICO.TRADABLE                      142.3            476.4
MEXICO.NONTRADABLE                   138.5            463.5
NEWZEALAND.TRADABLE                  15.1             47.8
NEWZEALAND.NONTRADABLE               34.1             107.9
PERU.TRADABLE                        17.9             67.4
PERU.NONTRADABLE                     28.7             108.1
PHILIPPINE.TRADABLE                  35.7             96.7
PHILIPPINE.NONTRADABLE               53.6             144.9
QATAR.TRADABLE                       50.4             66.9
QATAR.NONTRADABLE                    31.9             42.2
RUSSIAN.TRADABLE                     134.1            449.4
RUSSIAN.NONTRADABLE                  247.1            827.0
ARABIA.TRADABLE                      97.6             309.0
ARABIA.NONTRADABLE                   91.2             288.7
SINGAPORE.TRADABLE                   113.9            307.9
SINGAPORE.NONTRADABLE                65.4             177.0
THAILAND.TRADABLE                    71.9             215.7
THAILAND.NONTRADABLE                 54.3             163.0
US.TRADABLE                          1824             2099.9
US.NONTRADABLE                       2490.3           14130.1
VIETNAM.TRADABLE                     83.7             226.2
VIETNAM.NONTRADABLE                  31.1             84.2
ROW.TRADABLE                         2018.1           6390.6
ROW.NONTRADABLE                      637.3            2018.1   ;


TABLE ELASP0(R,G)
                    TRADABLE           NONTRADABLE
AUSTRALIA           1.0                1.0
BAHRAIN             1.0                1.0
BRAZIL              1.0                1.0
BRUNEI              1.0                1.0
CANADA              1.0                1.0
CHILE               1.0                1.0
CHINA               1.0                1.0
EU                  1.0                1.0
INDIA               1.0                1.0
INDONESIA           1.0                1.0
JAPAN               1.0                1.0
KOREA               1.0                1.0
KUWAIT              1.0                1.0
MALAYSIA            1.0                1.0
MEXICO              1.0                1.0
NEWZEALAND          1.0                1.0
PERU                1.0                1.0
PHILIPPINE          1.0                1.0
QATAR               1.0                1.0
RUSSIAN             1.0                1.0
ARABIA              1.0                1.0
SINGAPORE           1.0                1.0
THAILAND            1.0                1.0
US                  1.0                1.0
VIETNAM             1.0                1.0
ROW                 1.0                1.0  ;

TABLE GDEM1(R,RR)

                    AUSTRALIA   BAHRAIN   BRAZIL    BRUNEI   CANADA    CHILE    CHINA      EU       INDIA   INDONESIA   JAPAN     KOREA     KUWAIT   MALAYSIA   MEXICO
AUSTRALIA           128.6       0.075     0.664     0.582    1.703     0.372    57.699     41.871   3.846   2.801       4.242     10.182    0.042    8.311      1.001
BAHRAIN             0.946       5.2       0.673     0        0.186     0.103    1.878      2.548    0.769   0.087       0.795     0.251     0.112    0.137      0.074
BRAZIL              1.125       0.117     186.2     0.001    2.252     3.382    34.731     38.759   3.663   1.331       4.356     5.381     0.213    1.531      4.369
BRUNEI              0.047       0         0.001     2.1      0.007     0.002    1.641      0.721    0.069   0.072       0.001     0.097     0        0.451      0.004
CANADA              1.619       0.028     4.247     0.006    303.7     1.396    58.319     48.177   3.958   1.358       12.997    7.295     0.031    2.302      14.034
CHILE               0.258       0.001     6.678     0.001    0.889     24.7     17.504     11.612   0.977   0.194       2.491     1.871     0        0.247      2.059
CHINA               105.083     0.151     77.142    0.248    28.354    26.999   4024.1     245.173  18.851  27.127      180.402   204.566   15.359   34.413     7.169
EU                  13.169      1.695     37.131    0.152    36.031    9.562    465.022    2041.5   53.978  19.516      82.859    60.026    3.875    30.169     30.512
INDIA               14.081      0.585     4.621     0.433    3.467     1.669    73.605     52.755   800.3   13.725      12.537    16.388    7.805    8.991      1.378
INDONESIA           5.826       0.069     1.803     0.021    1.841     0.115    45.537     11.137   5.017   367.0       17.977    9.089     0.267    8.603      0.287
JAPAN               45.681      1.241     6.886     2.269    11.731    7.409    173.612    74.271   5.498   19.479      768.1     32.112    7.248    17.109     3.275
KOREA               20.717      0.563     3.908     0.611    5.751     4.475    106.488    57.541   5.885   9.532       54.603    196.0     12.794   8.344      2.277
KUWAIT              0           0.771     0.291     0.001    0.243     0.032    5.979      6.589    1.861   0.228       2.104     1.408     12.5     0.307      0.209
MALAYSIA            5.345       0.109     1.965     0.433    0.809     0.125    43.316     16.562   6.559   9.437       15.729    9.629     0.478    16.900     0.368
MEXICO              0.328       0.0445    6.508     0.001    10.752    1.667    83.509     45.984   5.232   1.587       18.189    16.725    0.017    2.073      168.0
NEWZEALAND          5.019       0.009     0.126     0.001    0.487     0.089    8.643      6.601    0.509   0.643       3.036     2.004     0.009    1.447      0.317
PERU                0.116       0.001     2.415     0        0.703     1.367    10.059     4.349    0.902   0.286       1.054     0.972     0.001    0.234      1.647
PHILIPPINE          1.538       0.024     0.642     0.036    0.791     0.041    22.579     8.932    1.784   6.789       11.397    11.503    1.394    4.285      0.154
QATAR               0.703       0.009     0.321     0        0.169     0.014    3.916      12.441   1.991   0.149       1.383     0.588     0.327    0.322      0.192
RUSSIAN             0.671       0.007     2.471     0        0.746     1.058    52.218     99.729   3.225   1.715       8.822     7.009     0        1.627      0.938
ARABIA              0.649       1.555     2.309     0.001    1.714     0.148    22.244     34.641   5.685   1.578       5.474     4.301     0.417    1.167      0.745
SINGAPORE           5.457       0.124     1.555     0.525    1.542     0.091    49.634     43.516   7.262   12.992      22.149    14.193    4.073    34.471     2.346
THAILAND            5.935       0.166     2.064     0.859    0.981     0.452    49.953     17.522   4.863   8.045       35.259    8.847     0.929    14.062     0.653
US                  10.209      1.025     32.286    0.102    325.684   12.201   563.203    472.782  56.444  18.472      145.902   76.201    2.126    22.525     344.661
VIETNAM             3.201       0.013     1.838     0.052    0.799     0.283    58.533     12.971   3.955   3.656       16.917    46.943    0.288    8.475      0.788
ROW                 5.077       5.918     41.355    0.265    12.768    2.448    484.378    941.016  119.717 19.401      77.525    57.219    14.095   35.697     31.243

+
                    NEWZEALAND  PERU    PHILIPPINE  QATAR    RUSSIAN   ARABIA   SINGAPORE  THAILAND     US        VIETNAM    ROW
AUSTRALIA           6.057       0.256    0.551      0.355    0.181     0.476    8.822      11.524       24.666    3.966      45.255
BAHRAIN             0.053       0.002    0.029      0        0.099     6.814    0.111      0.286        1.206     0.173      3.268
BRAZIL              0.061       1.811    0.271      0.273    3.374     2.319    0.646      1.651        29.351    2.059      38.173
BRUNEI              0.005       0        0.014      0.003    0.001     0.002    0.374      0.109        0.361     0.017      0.201
CANADA              0.579       1.099    1.121      0.069    1.141     2.939    0.974      2.749        235.118   3.014      55.33
CHILE               0.138       1.156    0.052      0        0.071     0.033    0.101      0.987        13.999    0.768      12.113
CHINA               11.079      15.213   8.698      9.091    58.887    45.899   33.638     44.919       156.004   41.366     739.069
EU                  4.075       7.183    9.359      8.525    179.625   36.076   23.509     26.886       313.541   45.089     837.535
INDIA               0.633       2.454    0.615      10.587   6.801     28.431   14.437     7.647        32.715    6.544      184.696
INDONESIA           0.808       0.056    0.958      1.411    1.551     4.911    21.439     10.953       10.212    3.534      25.278
JAPAN               2.651       2.454    9.473      14.856   15.587    33.775   9.733      25.058       83.571    18.834     124.387
KOREA               1.379       2.474    2.542      16.294   17.504    26.336   7.974      5.582        59.081    18.241     84.304
KUWAIT              0.068       0.004    0.071      0.051    0.229     2.042    0.151      0.409        3.104     0.527      9.221
MALAYSIA            0.826       0.112    1.929      0.676    1.157     4.433    25.474     12.035       16.094    4.065      39.735
MEXICO              0.291       0.474    0.606      0.059    1.969     0.089    1.669      6.359        216.271   2.239      41.658
NEWZEALAND          23.1        0.039    0.099      0.055    0.166     0.387    1.476      1.921        4.425     0.639      5.553
PERU                0.133       37.4     0.058      0.019    0.438     0.183    0.068      0.401        9.174     0.353      8.167
PHILIPPINE          0.518       0.108    64.9       0.389    1.301     1.892    6.311      7.948        8.297     3.465      12.982
QATAR               0.032       0.072    0.072      33.0     0.282     0.015    0.214      0.367        6.177     0.258      1.686
RUSSIAN             0.136       0.182    0.417      0.036    132.0     0.292    0.869      1.856        12.691    2.446      41.039
ARABIA              0.476       0.011    0.257      0        1.221     112.1    1.289      1.993        18.041    1.585      27.699
SINGAPORE           0.808       0.013    4.234      6.784    5.761     12.631   10.1       8.291        42.103    3.467      86.478
THAILAND            0.719       0.135    2.717      3.532    2.395     7.316    7.696      35.1         15.201    5.268      53.631
US                  4.364       8.272    10.551     1.619    21.596    24.616   26.879     33.027       2258.6    47.581     349.072
VIETNAM             0.502       0.117    1.158      0.138    1.392     1.309    5.319      10.702       9.343     66.2       48.208
ROW                 3.409       4.203    11.648     9.478    128.771   51.284   212.527    28.84        344.554   28.202     612.6   ;

TABLE ENDW(R,F)
                     K                L
AUSTRALIA            344.1            1089.8
BAHRAIN              12.1             25.6
BRAZIL               280.3            1588.3
BRUNEI               5.6              8.0
CANADA               394.1            1319.2
CHILE                68.6             229.6
CHINA                5987.6           7620.6
EU                   3937.2           14811.4
INDIA                842.8            1875.9
INDONESIA            364.8            677.4
JAPAN                1193.1           3778.2
KOREA                485.8            1133.6
KUWAIT               35.2             105.4
MALAYSIA             86.1             272.5
MEXICO               280.8            939.9
NEWZEALAND           49.2             155.7
PERU                 46.6             175.5
PHILIPPINE           89.3             241.6
QATAR                82.3             109.1
RUSSIAN              381.2            1276.4
ARABIA               188.8            597.7
SINGAPORE            179.3            484.9
THAILAND             126.2            378.7
US                   4314.3           16230.0
VIETNAM              114.8            310.4
ROW                  2655.4           8408.7   ;

TABLE TARIFF(R,RR)

                    AUSTRALIA  BAHRAIN  BRAZIL  BRUNEI  CANADA  CHILE  CHINA  EU     INDIA  INDONESIA  JAPAN  KOREA  KUWAIT  MALAYSIA  MEXICO
AUSTRALIA           0          0.025    0.025   0.025   0.025   0.025  0.025  0.025  0.025  0.025      0.025  0.025  0.025   0.025     0.025
BAHRAIN             0.053      0        0.053   0.053   0.053   0.053  0.053  0.053  0.053  0.053      0.053  0.053  0.053   0.053     0.053
BRAZIL              0.134      0.134    0       0.134   0.134   0.134  0.134  0.134  0.134  0.134      0.134  0.134  0.134   0.134     0.134
BRUNEI              0.321      0.321    0.321   0       0.321   0.321  0.321  0.321  0.321  0.321      0.321  0.321  0.321   0.321     0.321
CANADA              0.040      0.040    0.040   0.040   0       0.040  0.040  0.040  0.040  0.040      0.040  0.040  0.040   0.040     0.040
CHILE               0.060      0.060    0.060   0.060   0.060   0      0.060  0.060  0.060  0.060      0.060  0.060  0.060   0.060     0.060
CHINA               0.098      0.098    0.098   0.098   0.098   0.098  0      0.098  0.098  0.098      0.098  0.098  0.098   0.098     0.098
EU                  0.052      0.052    0.052   0.052   0.052   0.052  0.052  0      0.052  0.052      0.052  0.052  0.052   0.052     0.052
INDIA               0.171      0.171    0.171   0.171   0.171   0.171  0.171  0.171  0      0.171      0.171  0.171  0.171   0.171     0.171
INDONESIA           0.081      0.081    0.081   0.081   0.081   0.081  0.081  0.081  0.081  0          0.081  0.081  0.081   0.081     0.081
JAPAN               0.044      0.044    0.044   0.044   0.044   0.044  0.044  0.044  0.044  0.044      0      0.044  0.044   0.044     0.044
KOREA               0.137      0.137    0.137   0.137   0.137   0.137  0.137  0.137  0.137  0.137      0.137  0      0.137   0.137     0.137
KUWAIT              0.047      0.047    0.047   0.047   0.047   0.047  0.047  0.047  0.047  0.047      0.047  0.047  0       0.047     0.047
MALAYSIA            0.056      0.056    0.056   0.056   0.056   0.056  0.056  0.056  0.056  0.056      0.056  0.056  0.056   0         0.056
MEXICO              0.070      0.070    0.070   0.070   0.070   0.070  0.070  0.070  0.070  0.070      0.070  0.070  0.070   0.070     0
NEWZEALAND          0.020      0.020    0.020   0.020   0.020   0.020  0.020  0.020  0.020  0.020      0.020  0.020  0.020   0.020     0.020
PERU                0.024      0.024    0.024   0.024   0.024   0.024  0.024  0.024  0.024  0.024      0.024  0.024  0.024   0.024     0.024
PHILIPPINE          0.062      0.062    0.062   0.062   0.062   0.062  0.062  0.062  0.062  0.062      0.062  0.062  0.062   0.062     0.062
QATAR               0.048      0.048    0.048   0.048   0.048   0.048  0.048  0.048  0.048  0.048      0.048  0.048  0.048   0.048     0.048
RUSSIAN             0.068      0.068    0.068   0.068   0.068   0.068  0.068  0.068  0.068  0.068      0.068  0.068  0.068   0.068     0.068
ARABIA              0.053      0.053    0.053   0.053   0.053   0.053  0.053  0.053  0.053  0.053      0.053  0.053  0.053   0.053     0.053
SINGAPORE           0.001      0.001    0.001   0.001   0.001   0.001  0.001  0.001  0.001  0.001      0.001  0.001  0.001   0.001     0.001
THAILAND            0.096      0.096    0.096   0.096   0.096   0.096  0.096  0.096  0.096  0.096      0.096  0.096  0.096   0.096     0.096
US                  0.035      0.035    0.035   0.035   0.035   0.035  0.035  0.035  0.035  0.035      0.035  0.035  0.035   0.035     0.035
VIETNAM             0.095      0.095    0.095   0.095   0.095   0.095  0.095  0.095  0.095  0.095      0.095  0.095  0.095   0.095     0.095
ROW                 0.061      0.061    0.061   0.061   0.061   0.061  0.061  0.061  0.061  0.061      0.061  0.061  0.061   0.061     0.061

+
                    NEWZEALAND  PERU     PHILIPPINE  QATAR    RUSSIAN  ARABIA  SINGAPORE  THAILAND   US      VIETNAM  ROW
AUSTRALIA           0.025       0.025    0.025       0.025    0.025    0.025   0.025      0.025      0.025   0.025    0.025
BAHRAIN             0.053       0.053    0.053       0.053    0.053    0.053   0.053      0.053      0.053   0.053    0.053
BRAZIL              0.134       0.134    0.134       0.134    0.134    0.134   0.134      0.134      0.134   0.134    0.134
BRUNEI              0.321       0.321    0.321       0.321    0.321    0.321   0.321      0.321      0.321   0.321    0.321
CANADA              0.040       0.040    0.040       0.040    0.040    0.040   0.040      0.040      0.040   0.040    0.040
CHILE               0.060       0.060    0.060       0.060    0.060    0.060   0.060      0.060      0.060   0.060    0.060
CHINA               0.098       0.098    0.098       0.098    0.098    0.098   0.098      0.098      0.098   0.098    0.098
EU                  0.052       0.052    0.052       0.052    0.052    0.052   0.052      0.052      0.052   0.052    0.052
INDIA               0.171       0.171    0.171       0.171    0.171    0.171   0.171      0.171      0.171   0.171    0.171
INDONESIA           0.081       0.081    0.081       0.081    0.081    0.081   0.081      0.081      0.081   0.081    0.081
JAPAN               0.044       0.044    0.044       0.044    0.044    0.044   0.044      0.044      0.044   0.044    0.044
KOREA               0.137       0.137    0.137       0.137    0.137    0.137   0.137      0.137      0.137   0.137    0.137
KUWAIT              0.047       0.047    0.047       0.047    0.047    0.047   0.047      0.047      0.047   0.047    0.047
MALAYSIA            0.056       0.056    0.056       0.056    0.056    0.056   0.056      0.056      0.056   0.056    0.056
MEXICO              0.070       0.070    0.070       0.070    0.070    0.070   0.070      0.070      0.070   0.070    0.070
NEWZEALAND          0           0.020    0.020       0.020    0.020    0.020   0.020      0.020      0.020   0.020    0.020
PERU                0.024       0        0.024       0.024    0.024    0.024   0.024      0.024      0.024   0.024    0.024
PHILIPPINE          0.062       0.062    0           0.062    0.062    0.062   0.062      0.062      0.062   0.062    0.062
QATAR               0.048       0.048    0.048       0        0.048    0.048   0.048      0.048      0.048   0.048    0.048
RUSSIAN             0.068       0.068    0.068       0.068    0        0.068   0.068      0.068      0.068   0.068    0.068
ARABIA              0.053       0.053    0.053       0.053    0.053    0       0.053      0.053      0.053   0.053    0.053
SINGAPORE           0.001       0.001    0.001       0.001    0.001    0.001   0          0.001      0.001   0.001    0.001
THAILAND            0.096       0.096    0.096       0.096    0.096    0.096   0.096      0          0.096   0.096    0.096
US                  0.035       0.035    0.035       0.035    0.035    0.035   0.035      0.035      0       0.035    0.035
VIETNAM             0.095       0.095    0.095       0.095    0.095    0.095   0.095      0.095      0.095   0        0.095
ROW                 0.061       0.061    0.061       0.061    0.061    0.061   0.061      0.061      0.061   0.061    0       ;

TABLE NTARIFF(R,RR)

                    AUSTRALIA  BAHRAIN  BRAZIL  BRUNEI  CANADA  CHILE  CHINA  EU     INDIA  INDONESIA  JAPAN  KOREA  KUWAIT  MALAYSIA  MEXICO
AUSTRALIA           0          0.855    1.045   0.622   0.692   0.785  0.292  0.508  0.523  0.592      0.354  0.227  0.915   0.225     0.836
BAHRAIN             0.827      0        0.845   0.006   0.897   0.006  0.668  0.513  0.410  1.020      0.572  0.385  0.474   0.435     1.227
BRAZIL              0.936      0.764    0       0.001   0.487   0.321  0.277  0.310  0.453  0.740      0.492  0.258  0.653   0.364     0.409
BRUNEI              0.644      0.251    0.251   0       0.251   0.251  0.560  1.059  0.251  0.631      0.522  0.344  0.251   0.261     0.251
CANADA              0.677      0.910    0.581   0.002   0       0.529  0.333  0.321  0.499  0.709      0.374  0.287  0.926   0.389     0.237
CHILE               0.750      0.000    0.395   0.000   0.509   0      0.320  0.421  0.509  1.057      0.478  0.252  0.000   0.588     0.451
CHINA               0.219      0.623    0.313   0.465   0.275   0.282  0      0.206  0.312  0.363      0.156  0.035  0.427   0.034     0.379
EU                  0.481      0.514    0.392   1.010   0.309   0.429  0.252  0      0.318  0.607      0.369  0.203  0.449   0.220     0.382
INDIA               0.377      0.292    0.416   0.036   0.368   0.398  0.239  0.199  0      0.290      0.343  0.131  0.148   0.027     0.381
INDONESIA           0.536      0.992    0.793   0.553   0.668   1.036  0.380  0.578  0.380  0          0.346  0.228  0.762   0.112     0.917
JAPAN               0.335      0.581    0.582   0.481   0.370   0.494  0.210  0.377  0.470  0.383      0      0.101  0.376   0.131     0.504
KOREA               0.115      0.301    0.255   0.210   0.190   0.175  0.002  0.118  0.165  0.172      0.008  0      0.075   0.026     0.219
KUWAIT              0.893      0.480    0.740   0.000   0.919   0.000  0.478  0.454  0.272  0.796      0.373  0.165  0       0.614     0.000
MALAYSIA            0.194      0.432    0.442   0.208   0.373   0.592  0.076  0.216  0.142  0.137      0.119  0.007  0.605   0         0.519
MEXICO              0.791      1.210    0.473   0.009   0.207   0.441  0.407  0.364  0.482  0.928      0.478  0.286  0.009   0.505     0
NEWZEALAND          0.280      0.000    1.188   0.602   0.688   1.008  0.494  0.588  0.746  0.772      0.546  0.388  0.000   0.312     0.888
PERU                1.376      0.010    0.655   0.010   0.590   0.445  0.571  0.672  0.778  1.402      0.753  0.468  0.010   0.901     0.671
PHILIPPINE          0.714      0.001    0.891   0.880   0.645   1.081  0.426  0.612  0.711  0.642      0.399  0.242  1.201   0.263     0.819
QATAR               0.651      0.306    0.668   0.001   0.749   1.084  0.423  0.308  0.227  0.701      0.225  0.079  0.585   0.311     0.880
RUSSIAN             0.973      0.029    0.699   0.029   0.754   1.047  0.341  0.141  0.593  0.837      0.414  0.237  0.029   0.560     0.867
ARABIA              0.877      0.226    0.574   0.005   0.567   1.113  0.309  0.308  0.166  0.558      0.300  0.091  0.494   0.367     0.839
SINGAPORE           0.191      0.379    0.502   0.208   0.427   0.818  0.129  0.199  0.129  0.094      0.198  0.012  0.812   0.161     0.482
THAILAND            0.057      0.168    0.285   0.115   0.228   0.346  0.048  0.097  0.081  0.074      0.042  0.049  0.453   0.019     0.255
US                  0.528      0.632    0.418   1.061   0.001   0.376  0.250  0.249  0.367  0.604      0.298  0.177  0.470   0.217     0.036
VIETNAM             0.254      0.000    0.440   0.388   0.351   0.477  0.065  0.205  0.155  0.306      0.101  0.014  0.656   0.033     0.533
ROW                 0.160      0.027    0.121   0.476   0.178   0.221  0.659  0.663  0.724  0.461      0.074  0.056  0.122   0.070     0.185

+
                    NEWZEALAND  PERU     PHILIPPINE  QATAR   RUSSIAN  ARABIA  SINGAPORE  THAILAND    US      VIETNAM  ROW
AUSTRALIA           0.275       1.375    0.751       0.674   1.016    0.905   0.166      0.128       0.538   0.324    0.196
BAHRAIN             0.006       0.006    0.006       0.301   0.006    0.226   0.326      0.211       0.614   0.094    0.135
BRAZIL              1.074       0.545    0.819       0.582   0.633    0.493   0.368      0.247       0.319   0.401    0.048
BRUNEI              0.619       0.251    0.939       0.251   0.251    0.251   0.305      0.308       1.093   0.480    0.534
CANADA              0.668       0.574    0.667       0.757   0.782    0.580   0.387      0.284       0.084   0.406    0.199
CHILE               0.968       0.409    1.083       1.072   1.055    1.106   0.758      0.382       0.351   0.512    0.222
CHINA               0.416       0.497    0.390       0.373   0.311    0.264   0.031      0.086       0.187   0.062    0.122
EU                  0.556       0.644    0.622       0.304   0.157    0.309   0.147      0.141       0.232   0.248    0.072
INDIA               0.595       0.631    0.602       0.104   0.490    0.048   0.012      0.006       0.231   0.079    0.048
INDONESIA           0.711       1.345    0.623       0.668   0.824    0.530   0.013      0.089       0.558   0.320    0.441
JAPAN               0.522       0.733    0.417       0.229   0.438    0.309   0.154      0.094       0.289   0.152    0.091
KOREA               0.271       0.355    0.167       0.020   0.168    0.007   0.075      0.008       0.075   0.072    0.080
KUWAIT              0.000       0.000    1.216       0.586   0.000    0.500   0.765      0.502       0.458   0.704    0.136
MALAYSIA            0.276       0.869    0.269       0.303   0.572    0.364   0.105      0.059       0.196   0.172    0.075
MEXICO              0.838       0.625    0.811       0.858   0.865    0.822   0.412      0.281       0.101   0.558    0.176
NEWZEALAND          0           1.165    0.763       0.706   0.927    0.645   0.274      0.259       0.599   0.452    0.296
PERU                1.161       0.000    1.277       0.010   1.151    1.495   1.115      0.549       0.529   1.086    0.354
PHILIPPINE          0.721       1.239    0.000       0.713   1.030    0.824   0.152      0.146       0.551   0.422    0.655
QATAR               0.678       0.001    0.727       0.000   1.185    0.365   0.070      0.078       0.493   0.411    0.160
RUSSIAN             0.879       1.107    1.024       1.165   0.000    0.961   0.497      0.345       0.512   0.379    0.060
ARABIA              0.612       1.466    0.833       0.360   0.976    0.000   0.260      0.272       0.313   0.368    0.099
SINGAPORE           0.294       1.139    0.214       0.118   0.565    0.313   0.000      0.128       0.196   0.008    0.168
THAILAND            0.183       0.477    0.112       0.030   0.317    0.229   0.032      0.000       0.085   0.137    0.093
US                  0.584       0.518    0.578       0.506   0.545    0.331   0.161      0.146       0.000   0.265    0.040
VIETNAM             0.377       1.015    0.389       0.364   0.352    0.326   0.013      0.038       0.205   0.000    0.539
ROW                 0.255       0.317    0.656       0.147   0.067    0.091   0.107      0.048       0.047   0.573    0.000  ;

TABLE RTA(R,RR)

                    AUSTRALIA  BAHRAIN  BRAZIL  BRUNEI  CANADA  CHILE  CHINA  EU    INDIA  INDONESIA  JAPAN  KOREA  KUWAIT  MALAYSIA  MEXICO
AUSTRALIA           0          1        1       1       1       1      1      1     1      1          1      1      1       1         1
BAHRAIN             1          0        1       1       1       1      1      1     1      1          1      1      1       1         1
BRAZIL              1          1        0       1       1       1      1      1     1      1          1      1      1       1         1
BRUNEI              1          1        1       0       1       1      1      1     1      1          1      1      1       1         1
CANADA              1          1        1       1       0       1      1      1     1      1          1      1      1       1         1
CHILE               1          1        1       1       1       0      1      1     1      1          1      1      1       1         1
CHINA               1          1        1       1       1       1      0      1     1      1          1      1      1       1         1
EU                  1          1        1       1       1       1      1      0     1      1          1      1      1       1         1
INDIA               1          1        1       1       1       1      1      1     0      1          1      1      1       1         1
INDONESIA           1          1        1       1       1       1      1      1     1      0          1      1      1       1         1
JAPAN               1          1        1       1       1       1      1      1     1      1          0      1      1       1         1
KOREA               1          1        1       1       1       1      1      1     1      1          1      0      1       1         1
KUWAIT              1          1        1       1       1       1      1      1     1      1          1      1      0       1         1
MALAYSIA            1          1        1       1       1       1      1      1     1      1          1      1      1       0         1
MEXICO              1          1        1       1       1       1      1      1     1      1          1      1      1       1         0
NEWZEALAND          1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
PERU                1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
PHILIPPINE          1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
QATAR               1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
RUSSIAN             1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
ARABIA              1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
SINGAPORE           1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
THAILAND            1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
US                  1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
VIETNAM             1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
ROW                 1          1        1       1       1       1      1      1     1      1          1      1      1       1         1

+
                    NEWZEALAND  PERU  PHILIPPINE  QATAR  RUSSIAN   ARABIA  SINGAPORE  THAILAND  US  VIETNAM  ROW
AUSTRALIA           1           1     1           1      1         1       1          1         1   1        1
BAHRAIN             1           1     1           1      1         1       1          1         1   1        1
BRAZIL              1           1     1           1      1         1       1          1         1   1        1
BRUNEI              1           1     1           1      1         1       1          1         1   1        1
CANADA              1           1     1           1      1         1       1          1         1   1        1
CHILE               1           1     1           1      1         1       1          1         1   1        1
CHINA               1           1     1           1      1         1       1          1         1   1        1
EU                  1           1     1           1      1         1       1          1         1   1        1
INDIA               1           1     1           1      1         1       1          1         1   1        1
INDONESIA           1           1     1           1      1         1       1          1         1   1        1
JAPAN               1           1     1           1      1         1       1          1         1   1        1
KUWAIT              1           1     1           1      1         1       1          1         1   1        1
MALAYSIA            1           1     1           1      1         1       1          1         1   1        1
MEXICO              1           1     1           1      1         1       1          1         1   1        1
NEWZEALAND          0           1     1           1      1         1       1          1         1   1        1
PERU                1           0     1           1      1         1       1          1         1   1        1
PHILIPPINE          1           1     0           1      1         1       1          1         1   1        1
QATAR               1           1     1           0      1         1       1          1         1   1        1
RUSSIAN             1           1     1           1      0         1       1          1         1   1        1
ARABIA              1           1     1           1      1         0       1          1         1   1        1
SINGAPORE           1           1     1           1      1         1       0          1         1   1        1
THAILAND            1           1     1           1      1         1       1          0         1   1        1
US                  1           1     1           1      1         1       1          1         0   1        1
VIETNAM             1           1     1           1      1         1       1          1         1   0        1
ROW                 1           1     1           1      1         1       1          1         1   1        0  ;


TABLE FTA(R,RR)

                    AUSTRALIA  BAHRAIN  BRAZIL  BRUNEI  CANADA  CHILE  CHINA  EU    INDIA  INDONESIA  JAPAN  KOREA  KUWAIT  MALAYSIA  MEXICO
AUSTRALIA           0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
BAHRAIN             1          0        1       1       1       1      1      1     1      1          1      1      1       1         1
BRAZIL              1          1        0       1       1       1      1      1     1      1          1      1      1       1         1
BRUNEI              0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
CANADA              1          1        1       1       0       1      1      1     1      1          1      1      1       1         0
CHILE               1          1        1       1       1       0      1      1     1      1          1      1      1       1         1
CHINA               0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
EU                  1          1        1       1       1       1      1      0     1      1          0      1      1       1         1
INDIA               0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
INDONESIA           0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
JAPAN               0          1        1       0       1       1      0      0     0      0          0      0      1       0         1
KOREA               0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
KUWAIT              1          1        1       1       1       1      1      1     1      1          1      1      0       1         1
MALAYSIA            0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
MEXICO              1          1        1       1       0       1      1      1     1      1          1      1      1       1         0
NEWZEALAND          0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
PERU                1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
PHILIPPINE          0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
QATAR               1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
RUSSIAN             1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
ARABIA              1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
SINGAPORE           0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
THAILAND            0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
US                  1          1        1       1       0       1      1      0     1      1          0      1      1       1         0
VIETNAM             0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
ROW                 1          1        1       1       1       1      1      1     1      1          1      1      1       1         1

+
                    NEWZEALAND  PERU  PHILIPPINE  QATAR  RUSSIAN   ARABIA  SINGAPORE  THAILAND  US  VIETNAM  ROW
AUSTRALIA           0           1     0           1      1         1       0          0         1   0        1
BAHRAIN             1           1     1           1      1         1       1          1         1   1        1
BRAZIL              1           1     1           1      1         1       1          1         1   1        1
BRUNEI              0           1     0           1      1         1       0          0         1   0        1
CANADA              1           1     1           1      1         1       1          1         0   1        1
CHILE               1           1     1           1      1         1       1          1         1   1        1
CHINA               0           1     0           1      1         1       0          0         1   0        1
EU                  1           1     1           1      1         1       1          1         0   1        1
INDIA               0           1     0           1      1         1       0          0         1   0        1
INDONESIA           0           1     0           1      1         1       0          0         1   0        1
JAPAN               0           1     0           1      1         1       0          0         0   0        1
KOREA               0           1     0           1      1         1       0          0         1   0        1
KUWAIT              1           1     1           1      1         1       1          1         1   1        1
MALAYSIA            0           1     0           1      1         1       0          0         1   0        1
MEXICO              1           1     1           1      1         1       1          1         0   1        1
NEWZEALAND          0           1     0           1      1         1       0          0         1   0        1
PERU                1           0     1           1      1         1       1          1         1   1        1
PHILIPPINE          0           1     0           1      1         1       0          0         1   0        1
QATAR               1           1     1           0      1         1       1          1         1   1        1
RUSSIAN             1           1     1           1      0         1       1          1         1   1        1
ARABIA              1           1     1           1      1         0       1          1         1   1        1
SINGAPORE           0           1     0           1      1         1       0          0         1   0        1
THAILAND            0           1     0           1      1         1       0          0         1   0        1
US                  1           1     1           1      1         1       1          1         0   1        1
VIETNAM             0           1     0           1      1         1       0          0         1   0        1
ROW                 1           1     1           1      1         1       1          1         1   1        0   ;


TABLE WAR(R,RR)

                    AUSTRALIA  BAHRAIN  BRAZIL  BRUNEI  CANADA  CHILE  CHINA  EU    INDIA  INDONESIA  JAPAN  KOREA  KUWAIT  MALAYSIA  MEXICO
AUSTRALIA           0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
BAHRAIN             0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
BRAZIL              0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
BRUNEI              0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
CANADA              0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
CHILE               0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
CHINA               0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
EU                  0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
INDIA               0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
INDONESIA           0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
JAPAN               0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
KOREA               0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
KUWAIT              0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
MALAYSIA            0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
MEXICO              0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
NEWZEALAND          0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
PERU                0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
PHILIPPINE          0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
QATAR               0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
RUSSIAN             0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
ARABIA              0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
SINGAPORE           0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
THAILAND            0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
US                  0          0        0       0       0       0      1      0     0      0          0      0      0       0         0
VIETNAM             0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
ROW                 0          0        0       0       0       0      0      0     0      0          0      0      0       0         0

+
                    NEWZEALAND  PERU  PHILIPPINE  QATAR  RUSSIAN   ARABIA  SINGAPORE  THAILAND  US  VIETNAM  ROW
AUSTRALIA           0           0     0           0      0         0       0          0         0   0        0
BAHRAIN             0           0     0           0      0         0       0          0         0   0        0
BRAZIL              0           0     0           0      0         0       0          0         0   0        0
BRUNEI              0           0     0           0      0         0       0          0         0   0        0
CANADA              0           0     0           0      0         0       0          0         0   0        0
CHILE               0           0     0           0      0         0       0          0         0   0        0
CHINA               0           0     0           0      0         0       0          0         1   0        0
EU                  0           0     0           0      0         0       0          0         0   0        0
INDIA               0           0     0           0      0         0       0          0         0   0        0
INDONESIA           0           0     0           0      0         0       0          0         0   0        0
JAPAN               0           0     0           0      0         0       0          0         0   0        0
KOREA               0           0     0           0      0         0       0          0         0   0        0
KUWAIT              0           0     0           0      0         0       0          0         0   0        0
MALAYSIA            0           0     0           0      0         0       0          0         0   0        0
MEXICO              0           0     0           0      0         0       0          0         0   0        0
NEWZEALAND          0           0     0           0      0         0       0          0         0   0        0
PERU                0           0     0           0      0         0       0          0         0   0        0
PHILIPPINE          0           0     0           0      0         0       0          0         0   0        0
QATAR               0           0     0           0      0         0       0          0         0   0        0
RUSSIAN             0           0     0           0      0         0       0          0         0   0        0
ARABIA              0           0     0           0      0         0       0          0         0   0        0
SINGAPORE           0           0     0           0      0         0       0          0         0   0        0
THAILAND            0           0     0           0      0         0       0          0         0   0        0
US                  0           0     0           0      0         0       0          0         0   0        0
VIETNAM             0           0     0           0      0         0       0          0         0   0        0
ROW                 0           0     0           0      0         0       0          0         0   0        0   ;




***************CALIBRATION**************
PARAMETERS

DISTN(R,G,F)      SHARE PARAMETER IN PRODUCTION FUNCTION
SCALE(R,G)        SCALE PAREMETER IN PRODUCTION

SHARE1(R)         SHARE PARAMETER OF COMPOSITE TRADABLE GOODS
SHARE2(R)         SHARE PARAMETER OF NONTRADABLE GOODS
SHARE3(R)         SHARE PARAMETER OF INSIDE MONEY
SHARE4(R,RR)      SHARE PARAMETER OF TRADABLE GOODS
PM1(R)            PRICE FOR COMPOSITE TRADABLE GOODS

ELASC1(R)         FIRST LEVEL CONSUMPTION ELASTICITY OF SUBSITUTION
ELASC2(R)         SECOND LEVEL CONSUMPTION ELASTICITY OF SUBSTITUTION
ELASP(R,G)        PRODUCTION ELASTICITY OF SUBSITUTION
;


ELASC1(R) = ELASC10(R)*3.0;
ELASC2(R) = ELASC20(R)*3.0;
ELASP(R,G) = ELASP0(R,G)*3.0;

DISTN(R,G,F) = ((FACDEM1(R,G,F)**(1/ELASP(R,G))))/SUM(FF,(FACDEM1(R,G,FF)**(1/ELASP(R,G))));
SCALE(R,G) = PRN1(R,G)/(SUM(F,DISTN(R,G,F)*(FACDEM1(R,G,F)**((ELASP(R,G)-1)/ELASP(R,G))))**(ELASP(R,G)/(ELASP(R,G)-1)));

SHARE4(R,RR) = GDEM1(R,RR)*((1+TARIFF(R,RR)+NTARIFF(R,RR))**ELASC2(R))/SUM(RRR,GDEM1(R,RRR)*((1+TARIFF(R,RRR)+NTARIFF(R,RRR))**ELASC2(R)));
PM1(R) = (SUM(RR,SHARE4(R,RR)*((1+TARIFF(R,RR)+NTARIFF(R,RR))**(1-ELASC2(R)))))**(1/(1-ELASC2(R)));
SHARE1(R) = TGDEM1(R)*(PM1(R)**ELASC1(R))/(TGDEM1(R)*(PM1(R)**ELASC1(R))+MONEY1(R)+NGDEM1(R));
SHARE2(R) = NGDEM1(R)/(TGDEM1(R)*(PM1(R)**ELASC1(R))+MONEY1(R)+NGDEM1(R));
SHARE3(R) = MONEY1(R)/(TGDEM1(R)*(PM1(R)**ELASC1(R))+MONEY1(R)+NGDEM1(R));

DISPLAY DISTN,SCALE,PM1,SHARE1,SHARE2,SHARE3,SHARE4,ELASC1,ELASC2,ELASP;


********************MODEL SYSTEM********************
VARIABLES
PRN(R,G)            PRODUCTION OF SECTORS
FACDEM(R,G,F)       FACTOR DEMAND BY GOODS

TGDEM(R)            TRADABLE COMPOSITE GOODS
NGDEM(R)            NONTRADABLE GOODS
MONEY(R)            INSIDE MONEY
GDEM(R,RR)          TRADABLE GOODS DEMAND

P(R,G)              PRICE OF PRODUCTION
PRCT(R,RR)          PRICE OF TRADABLE GOODS
PRCN(R)             PRICE OF NON-TRADABLE GOODS
PRCM(R)             PRICE OF INSIDE MONEY
PM(R)               PRICE OF COMPOSITE TRADABLE GOODS
W(R,F)              WAGES BY FACTORS

SURPLUS(R)          TRADE IMBALANCE DENOTED BY INSIDE MONEY
REV(R)              REVENUE COLLECTION
NREV(R)             COSTS FOR SOLVING NON-TARIFF TRADE COSTS
INC(R)              INCOME BY INDIVIDUAL

Z(R)                EXCESS DEMAND OF TRADABLE GOODS
DMY                 A DUMMY OBJECTIVE VARIABLE

EQUATIONS
PRNDEF(R,G)         DEFINITION OF PRODUCTION FUNCTION
FACDEMDEF(R,G,F)    DEFINITION OF FACTOR DEMAND

TGDEMDEF(R)         DEFINITION OF TRADABLE COMPOSITE GOODS
NGDEMDEF(R)         DEFINITION OF NON-TRADABLE GOODS
MONEYDEF(R)         DEFINITION OF INSIDE MONEY
GDEMDEF(R,RR)       DEFINITION OF TRADABLE GOODS DEMAND

PRCTDEF(R,RR)       DEFINITION OF TRADABLE GOODS CONSUMER PRICE
PRCNDEF(R)          DEFINITION OF NONTRADABLE GOODS CONSUMER PRICE
PMDEF(R)            DEFINITION OF AMINGTON PRICES

SURPLUSDEF(R)       DEFINITION OF TRADE IMBALANCE DENOTED BY INSIDE MONEY
REVDEF(R)           DEFINITION OF REVENUE COLLECTION
NREVDEF(R)          DEFINITION OF COSTS FOR SLOVING NON-TARIFF BARRIERS
INCDEF(R)           INCOME DEFINITION

FACDEF(R,F)         DEFINITION OF FACTOR CLEARANCE
ZPROF(R,G)          ZERO PROFIT CONDITION
SDEF                SURPLUS CLEARANCE DEFINITION
NGDEF(R)            NONTRADABLE GOODS CLEARANCE CONDITION
TGDEF(R)            TRADABLE GOODS CLEARANCE CONDITION

DMYOBJ              DEFINITION OF DUMMY OBJECTIVE FUNCTION
;

PRNDEF(R,G)..
PRN(R,G) =E= SCALE(R,G)*SUM(F,DISTN(R,G,F)*(FACDEM(R,G,F)**
((ELASP(R,G)-1)/ELASP(R,G))))**(ELASP(R,G)/(ELASP(R,G)-1));

FACDEMDEF(R,G,F)..
FACDEM(R,G,F) =E= (1/SCALE(R,G))*PRN(R,G)*(DISTN(R,G,F)+((SUM(FF,DISTN(R,G,FF))
-DISTN(R,G,F))*((DISTN(R,G,F)*(SUM(FF,W(R,FF))-W(R,F)))/((SUM(FF,DISTN(R,G,FF))-DISTN(R,G,F))*W(R,F)))**
(1-ELASP(R,G))))**(ELASP(R,G)/(1-ELASP(R,G)));

TGDEMDEF(R)..
TGDEM(R) =E= (SHARE1(R)*INC(R))/((PM(R)**ELASC1(R))*(SHARE1(R)*(PM(R)**(1-ELASC1(R)))+SHARE2(R)*(PRCN(R)**
(1-ELASC1(R)))+SHARE3(R)*(PRCM(R)**(1-ELASC1(R)))));

NGDEMDEF(R)..
NGDEM(R) =E= (SHARE2(R)*INC(R))/((PRCN(R)**ELASC1(R))*(SHARE1(R)*(PM(R)**(1-ELASC1(R)))+SHARE2(R)*(PRCN(R)**
(1-ELASC1(R)))+SHARE3(R)*(PRCM(R)**(1-ELASC1(R)))));

MONEYDEF(R)..
MONEY(R) =E= (SHARE3(R)*INC(R))/((PRCM(R)**ELASC1(R))*(SHARE1(R)*(PM(R)**(1-ELASC1(R)))+SHARE2(R)*(PRCN(R)**
(1-ELASC1(R)))+SHARE3(R)*(PRCM(R)**(1-ELASC1(R)))));

GDEMDEF(R,RR)..
GDEM(R,RR) =E= (SHARE4(R,RR)*PM(R)*TGDEM(R))/((PRCT(R,RR)**ELASC2(R))*SUM(RRR,SHARE4(R,RRR)*(PRCT(R,RRR)**(1-ELASC2(R)))));

PRCTDEF(R,RR)..
PRCT(R,RR) =E= P(RR,"TRADABLE")*(1+TARIFF(R,RR)*FTA(R,RR)+NTARIFF(R,RR)*(FTA(R,RR)+0.7*(RTA(R,RR)-FTA(R,RR))));

PRCNDEF(R)..
PRCN(R) =E= P(R,"NONTRADABLE");

PMDEF(R)..
PM(R) =E= (SUM(RR,SHARE4(R,RR)*(PRCT(R,RR)**(1-ELASC2(R)))))**(1/(1-ELASC2(R)));

SURPLUSDEF(R)..
SURPLUS(R) =E= MONEY(R)-1000;

REVDEF(R)..
REV(R) =E= SUM(RR,GDEM(R,RR)*P(RR,"TRADABLE")*TARIFF(R,RR)*FTA(R,RR));

NREVDEF(R)..
NREV(R) =E= SUM(RR,GDEM(R,RR)*P(RR,"TRADABLE")*NTARIFF(R,RR)*(FTA(R,RR)+0.7*(RTA(R,RR)-FTA(R,RR))));

INCDEF(R)..
INC(R) =E= SUM(FF,ENDW(R,FF)*W(R,FF))+REV(R)+1000;

FACDEF(R,F)..
ENDW(R,F) =E= SUM(G,FACDEM(R,G,F));

ZPROF(R,G)..
PRN(R,G)*P(R,G) =E= SUM(F,FACDEM(R,G,F)*W(R,F));

SDEF..
SUM(R,SURPLUS(R)) =E= 0;

NGDEF(R)..
NGDEM(R) =E= PRN(R,"NONTRADABLE")-(NREV(R)/PRCN(R));

TGDEF(R)..
Z(R) =E= SUM(RR,GDEM(RR,R))-PRN(R,"TRADABLE");

DMYOBJ..
DMY =E= SUM(R,P(R,"TRADABLE")*Z(R)*P(R,"TRADABLE")*Z(R))/10000;

MODEL CHUNDING /ALL/;

PRN.LO(R,G)=0.1;
PRN.LO("AUSTRALIA",G)=100;
PRN.LO("BAHRAIN",G)=2;
PRN.LO("BRAZIL",G)=100;
PRN.LO("BRUNEI",G)=1;
PRN.LO("CANADA",G)=100;
PRN.LO("CHILE",G)=10;
PRN.LO("CHINA",G)=1000;
PRN.LO("EU",G)=1000;
PRN.LO("INDIA",G)=100;
PRN.LO("INDONESIA",G)=50;
PRN.LO("JAPAN",G)=100;
PRN.LO("KOREA",G)=60;
PRN.LO("KUWAIT",G)=1;
PRN.LO("MALAYSIA",G)=10;
PRN.LO("MEXICO",G)=50;
PRN.LO("NEWZEALAND",G)=2;
PRN.LO("PERU",G)=10;
PRN.LO("PHILIPPINE",G)=10;
PRN.LO("QATAR",G)=6;
PRN.LO("RUSSIAN",G)=100;
PRN.LO("ARABIA",G)=10;
PRN.LO("SINGAPORE",G)=100;
PRN.LO("THAILAND",G)=5;
PRN.LO("US",G)=100;
PRN.LO("VIETNAM",G)=10;
PRN.LO("ROW",G)=500;

FACDEM.LO(R,G,F)=0.1;
FACDEM.LO("AUSTRALIA",G,F)=60;
FACDEM.LO("BAHRAIN",G,F)=1;
FACDEM.LO("BRAZIL",G,F)=10;
FACDEM.LO("BRUNEI",G,F)=0.1;
FACDEM.LO("CANADA",G,F)=20;
FACDEM.LO("CHILE",G,F)=5;
FACDEM.LO("CHINA",G,F)=600;
FACDEM.LO("EU",G,F)=600;
FACDEM.LO("INDIA",G,F)=20;
FACDEM.LO("INDONESIA",G,F)=30;
FACDEM.LO("JAPAN",G,F)=60;
FACDEM.LO("KOREA",G,F)=50;
FACDEM.LO("KUWAIT",G,F)=1;
FACDEM.LO("MALAYSIA",G,F)=10;
FACDEM.LO("MEXICO",G,F)=20;
FACDEM.LO("NEWZEALAND",G,F)=2;
FACDEM.LO("PERU",G,F)=5;
FACDEM.LO("PHILIPPINE",G,F)=6;
FACDEM.LO("QATAR",G,F)=3;
FACDEM.LO("RUSSIAN",G,F)=20;
FACDEM.LO("ARABIA",G,F)=20;
FACDEM.LO("SINGAPORE",G,F)=5;
FACDEM.LO("THAILAND",G,F)=2;
FACDEM.LO("US",G,F)=100;
FACDEM.LO("VIETNAM",G,F)=2;
FACDEM.LO("ROW",G,F)=200;

TGDEM.LO(R)=0.1;
TGDEM.LO("AUSTRALIA")=100;
TGDEM.LO("BAHRAIN")=2;
TGDEM.LO("BRAZIL")=60;
TGDEM.LO("BRUNEI")=1;
TGDEM.LO("CANADA")=100;
TGDEM.LO("CHILE")=10;
TGDEM.LO("CHINA")=1000;
TGDEM.LO("EU")=1000;
TGDEM.LO("INDIA")=100;
TGDEM.LO("INDONESIA")=60;
TGDEM.LO("JAPAN")=300;
TGDEM.LO("KOREA")=100;
TGDEM.LO("KUWAIT")=5;
TGDEM.LO("MALAYSIA")=50;
TGDEM.LO("MEXICO")=100;
TGDEM.LO("NEWZEALAND")=10;
TGDEM.LO("PERU")=10;
TGDEM.LO("PHILIPPINE")=20;
TGDEM.LO("QATAR")=5;
TGDEM.LO("RUSSIAN")=100;
TGDEM.LO("ARABIA")=60;
TGDEM.LO("SINGAPORE")=60;
TGDEM.LO("THAILAND")=60;
TGDEM.LO("US")=1000;
TGDEM.LO("VIETNAM")=20;
TGDEM.LO("ROW")=1000;

NGDEM.LO(R)=0.1;
NGDEM.LO("AUSTRALIA")=100;
NGDEM.LO("BAHRAIN")=1;
NGDEM.LO("BRAZIL")=100;
NGDEM.LO("BRUNEI")=1;
NGDEM.LO("CANADA")=500;
NGDEM.LO("CHILE")=10;
NGDEM.LO("CHINA")=1000;
NGDEM.LO("EU")=1000;
NGDEM.LO("INDIA")=500;
NGDEM.LO("INDONESIA")=60;
NGDEM.LO("JAPAN")=600;
NGDEM.LO("KOREA")=100;
NGDEM.LO("KUWAIT")=5;
NGDEM.LO("MALAYSIA")=10;
NGDEM.LO("MEXICO")=100;
NGDEM.LO("NEWZEALAND")=10;
NGDEM.LO("PERU")=10;
NGDEM.LO("PHILIPPINE")=20;
NGDEM.LO("QATAR")=5;
NGDEM.LO("RUSSIAN")=100;
NGDEM.LO("ARABIA")=20;
NGDEM.LO("SINGAPORE")=60;
NGDEM.LO("THAILAND")=10;
NGDEM.LO("US")=1000;
NGDEM.LO("VIETNAM")=10;
NGDEM.LO("ROW")=500;

MONEY.LO(R)=100;
MONEY.LO("AUSTRALIA")=800;
MONEY.LO("BAHRAIN")=800;
MONEY.LO("BRAZIL")=800;
MONEY.LO("BRUNEI")=800;
MONEY.LO("CANADA")=600;
MONEY.LO("CHILE")=600;
MONEY.LO("CHINA")=900;
MONEY.LO("EU")=800;
MONEY.LO("INDIA")=500;
MONEY.LO("INDONESIA")=600;
MONEY.LO("JAPAN")=500;
MONEY.LO("KOREA")=800;
MONEY.LO("KUWAIT")=800;
MONEY.LO("MALAYSIA")=800;
MONEY.LO("MEXICO")=600;
MONEY.LO("NEWZEALAND")=600;
MONEY.LO("PERU")=600;
MONEY.LO("PHILIPPINE")=600;
MONEY.LO("QATAR")=800;
MONEY.LO("RUSSIAN")=900;
MONEY.LO("ARABIA")=900;
MONEY.LO("SINGAPORE")=800;
MONEY.LO("THAILAND")=600;
MONEY.LO("US")=100;
MONEY.LO("VIETNAM")=600;
MONEY.LO("ROW")=800;

REV.LO(R)=0.05;
REV.LO("AUSTRALIA")=2;
REV.LO("BAHRAIN")=0.1;
REV.LO("BRAZIL")=6;
REV.LO("BRUNEI")=0.2;
REV.LO("CANADA")=6;
REV.LO("CHILE")=2;
REV.LO("CHINA")=60;
REV.LO("EU")=20;
REV.LO("INDIA")=10;
REV.LO("INDONESIA")=3;
REV.LO("JAPAN")=10;
REV.LO("KOREA")=10;
REV.LO("KUWAIT")=0.2;
REV.LO("MALAYSIA")=2;
REV.LO("MEXICO")=2;
REV.LO("NEWZEALAND")=0.2;
REV.LO("PERU")=0.3;
REV.LO("PHILIPPINE")=1;
REV.LO("QATAR")=0.2;
REV.LO("RUSSIAN")=2;
REV.LO("ARABIA")=2;
REV.LO("SINGAPORE")=0.1;
REV.LO("THAILAND")=2;
REV.LO("US")=10;
REV.LO("VIETNAM")=2;
REV.LO("ROW")=50;

NREV.LO(R)=0.1;
NREV.LO("AUSTRALIA")=10;
NREV.LO("BAHRAIN")=1;
NREV.LO("BRAZIL")=6;
NREV.LO("BRUNEI")=0.2;
NREV.LO("CANADA")=6;
NREV.LO("CHILE")=2;
NREV.LO("CHINA")=60;
NREV.LO("EU")=20;
NREV.LO("INDIA")=10;
NREV.LO("INDONESIA")=10;
NREV.LO("JAPAN")=50;
NREV.LO("KOREA")=10;
NREV.LO("KUWAIT")=2;
NREV.LO("MALAYSIA")=2;
NREV.LO("MEXICO")=10;
NREV.LO("NEWZEALAND")=2;
NREV.LO("PERU")=3;
NREV.LO("PHILIPPINE")=5;
NREV.LO("QATAR")=1;
NREV.LO("RUSSIAN")=10;
NREV.LO("ARABIA")=6;
NREV.LO("SINGAPORE")=10;
NREV.LO("THAILAND")=2;
NREV.LO("US")=60;
NREV.LO("VIETNAM")=2;
NREV.LO("ROW")=100;

INC.LO(R)=1;
INC.LO("AUSTRALIA")=600;
INC.LO("BAHRAIN")=10;
INC.LO("BRAZIL")=600;
INC.LO("BRUNEI")=2;
INC.LO("CANADA")=600;
INC.LO("CHILE")=60;
INC.LO("CHINA")=1000;
INC.LO("EU")=2000;
INC.LO("INDIA")=500;
INC.LO("INDONESIA")=100;
INC.LO("JAPAN")=500;
INC.LO("KOREA")=100;
INC.LO("KUWAIT")=10;
INC.LO("MALAYSIA")=60;
INC.LO("MEXICO")=100;
INC.LO("NEWZEALAND")=20;
INC.LO("PERU")=50;
INC.LO("PHILIPPINE")=60;
INC.LO("QATAR")=10;
INC.LO("RUSSIAN")=500;
INC.LO("ARABIA")=100;
INC.LO("SINGAPORE")=100;
INC.LO("THAILAND")=100;
INC.LO("US")=1000;
INC.LO("VIETNAM")=10;
INC.LO("ROW")=1000;

*GDEM.LO(R,RR)=0.1;

P.LO(R,G)=0.3;
PRCT.LO(R,RR)=0.4;
PRCN.LO(R)=0.4;
PM.LO(R)=0.4;
W.LO(R,F)=0.3;
PRCM.FX(R)=1;
W.FX("ARABIA","L")=1;

SOLVE CHUNDING USING NLP MINIMIZING DMY;

DISPLAY PRN.L, FACDEM.L, TGDEM.L, NGDEM.L, MONEY.L, GDEM.L, P.L, PRCT.L, PRCN.L, PM.L, W.L, SURPLUS.L, REV.L, INC.L;


***************SPECIFIC CALCULATION******************
PARAMETERS

PRODUCTION0(R)
/AUSTRALIA   1308.256,    BAHRAIN       28.083,    BRAZIL      1747.126
BRUNEI         8.703,    CANADA      2063.416,    CHILE        255.857
CHINA      14683.051,    EU         20659.595,    INDIA       2741.432
INDONESIA    906.548,    JAPAN       5148.397,    KOREA       1654.101
KUWAIT        96.966,    MALAYSIA     343.907,    MEXICO      1570.827
NEWZEALAND   177.700,    PERU         187.638,    PHILIPPINE   264.124
QATAR        130.532,    RUSSIAN     1639.791,    ARABIA       786.500
SINGAPORE    715.616,    THAILAND     485.311,    US         25911.107
VIETNAM      454.368,    ROW         9892.388/,


EXPORT0(R)        TOTAL EXPORT OF ONE COUNTRY IN BASE CASE
/AUSTRALIA   358.197,    BAHRAIN      40.394,    BRAZIL      395.413
BRUNEI       17.811,    CANADA      538.312,    CHILE       135.073
CHINA      3216.247,    EU         3174.880,    INDIA       518.945
INDONESIA   308.013,    JAPAN       958.329,    KOREA       775.176
KUWAIT      199.308,    MALAYSIA    354.632,    MEXICO      490.715
NEWZEALAND   67.721,    PERU         92.428,    PHILIPPINE  150.775
QATAR       221.087,    RUSSIAN     695.617,    ARABIA      398.572
SINGAPORE   585.696,    THAILAND    363.057,    US         1460.076
VIETNAM     300.355,    ROW        4562.098/,

IMPORT0(R)        TOTAL IMPORT OF ONE COUNTRY IN BASE CASE
/AUSTRALIA   204.639,    BAHRAIN      21.410,    BRAZIL      157.608
BRUNEI        4.245,    CANADA      507.407,    CHILE        64.402
CHINA      2726.969,    EU         3089.669,    INDIA       564.536
INDONESIA   158.926,    JAPAN       836.922,    KOREA       564.711
KUWAIT       33.900,    MALAYSIA    213.927,    MEXICO      527.230
NEWZEALAND   41.603,    PERU         39.785,    PHILIPPINE  105.015
QATAR        25.226,    RUSSIAN     228.247,    ARABIA      133.049
SINGAPORE   400.624,    THAILAND    249.140,    US         4403.699
VIETNAM     251.221,    ROW        4824.815/,

BALANCE0(R)       TOTAL IMBALNCE OF ONE COUNTRY IN BASE CASE
/AUSTRALIA    153.558,    BAHRAIN       18.983,    BRAZIL       237.805
BRUNEI        13.566,    CANADA        30.905,    CHILE         70.671
CHINA        489.278,    EU            85.211,    INDIA        -45.591
INDONESIA    149.087,    JAPAN        121.406,    KOREA        210.464
KUWAIT       165.408,    MALAYSIA     140.706,    MEXICO       -36.515
NEWZEALAND    26.118,    PERU          52.643,    PHILIPPINE    45.761
QATAR        195.861,    RUSSIAN      467.369,    ARABIA       265.523
SINGAPORE    185.072,    THAILAND     113.917,    US         -2943.623
VIETNAM       49.134,    ROW         -262.717/,

TRADE0(R)         TOTAL TRADE OF ONE COUNTRY IN BASE CASE
/AUSTRALIA   562.836,    BAHRAIN      61.804,    BRAZIL      553.021
BRUNEI       22.055,    CANADA     1045.719,    CHILE       199.475
CHINA      5943.215,    EU         6264.549,    INDIA      1083.481
INDONESIA   466.939,    JAPAN      1795.251,    KOREA      1339.887
KUWAIT      233.208,    MALAYSIA    568.559,    MEXICO     1017.944
NEWZEALAND  109.324,    PERU        132.213,    PHILIPPINE  255.790
QATAR       246.313,    RUSSIAN     923.864,    ARABIA      531.621
SINGAPORE   986.320,    THAILAND    612.196,    US         5863.776
VIETNAM     551.576,    ROW        9386.912/,

NGDEM0(R)       NON-TRADABLE GOODS DEMAND IN BASE CASE
/AUSTRALIA   1110.872,    BAHRAIN       23.879,    BRAZIL      1508.099
BRUNEI         8.670,    CANADA       672.877,    CHILE        250.226
CHINA       6274.783,    EU         13231.592,    INDIA       1470.339
INDONESIA    530.402,    JAPAN       3150.780,    KOREA        749.528
KUWAIT       119.693,    MALAYSIA      74.613,    MEXICO       316.027
NEWZEALAND   175.297,    PERU         171.929,    PHILIPPINE   244.865
QATAR        171.151,    RUSSIAN     1034.677,    ARABIA       342.174
SINGAPORE    144.456,    THAILAND     215.596,    US         15038.040
VIETNAM       59.810,    ROW         1638.715/,

UTILITY0(R)     TOTAL UTILITY IN BASE CASE
/AUSTRALIA   1780.385,    BAHRAIN      241.306,    BRAZIL      2221.005
BRUNEI       138.564,    CANADA      1985.700,    CHILE        639.954
CHINA      13680.844,    EU         18831.360,    INDIA       3197.474
INDONESIA   1436.153,    JAPAN       5214.571,    KOREA       1998.879
KUWAIT       412.876,    MALAYSIA     657.001,    MEXICO      1494.101
NEWZEALAND   526.692,    PERU         542.790,    PHILIPPINE   720.831
QATAR        506.784,    RUSSIAN     1875.698,    ARABIA      1019.541
SINGAPORE    989.545,    THAILAND     876.393,    US         21296.944
VIETNAM      755.057,    ROW         7331.318/,

PRCN0(R)       CONSUMPTION PICE OF NON-TRADABLE GOODS IN BASE CASE
/AUSTRALIA  0.912,    BAHRAIN    0.745,    BRAZIL     0.935,    BRUNEI     0.640
CANADA     1.204,    CHILE      0.858,    CHINA      1.079,    EU         1.102
INDIA      1.008,    INDONESIA  0.870,    JAPAN      1.036,    KOREA      1.021
KUWAIT     0.690,    MALAYSIA   0.959,    MEXICO     1.287,    NEWZEALAND 0.867
PERU       0.845,    PHILIPPINE 0.798,    QATAR      0.682,    RUSSIAN    0.989
ARABIA     1.000,    SINGAPORE  1.077,    THAILAND   0.961,    US         1.259
VIETNAM    1.069,    ROW        0.894/,

EMPLOYMENT0(R)
/AUSTRALIA   190.107,    BAHRAIN       2.077,    BRAZIL      268.119
BRUNEI        0.612,    CANADA      728.910,    CHILE        16.670
CHINA      3870.525,    EU         3954.614,    INDIA       808.168
INDONESIA   290.177,    JAPAN      1234.258,    KOREA       582.432
KUWAIT        3.008,    MALAYSIA    194.454,    MEXICO      613.558
NEWZEALAND    6.332,    PERU         18.825,    PHILIPPINE   16.263
QATAR         3.990,    RUSSIAN     437.724,    ARABIA      310.736
SINGAPORE   328.781,    THAILAND    201.186,    US         2709.779
VIETNAM     230.745,    ROW        5406.224/,

GDEM0(R,RR)     GOODS DEMAND IN THE BASE CASE
PRCT0(R,RR)     CONSUMPTION PRICE OF TRADABLE GOODS IN BASE CASE
;


TABLE GDEM0(R,RR)
             AUSTRALIA     BAHRAIN      BRAZIL      BRUNEI      CANADA

AUSTRALIA      153.935       0.165       0.739       2.021       0.886
BAHRAIN          1.295      13.079       0.856                   0.111
BRAZIL           1.387       0.265     213.375       0.004       1.208
BRUNEI           0.069                   0.001       8.994       0.004
CANADA           2.972       0.094       7.244       0.032     242.388
CHILE            0.323       0.002       7.778       0.004       0.484
CHINA          165.742       0.438     113.055       1.135      19.444
EU              22.597       5.344      59.201       0.757      26.880
INDIA           19.053       1.454       5.810       1.700       2.040
INDONESIA        6.662       0.145       1.916       0.070       0.915
JAPAN           66.274       3.308       9.283       9.552       7.400
KOREA           28.167       1.406       4.937       2.410       3.400
KUWAIT                       1.782       0.340       0.004       0.133
MALAYSIA         6.999       0.262       2.391       1.645       0.461
MEXICO           0.615       0.153      11.338       0.005       8.765
NEWZEALAND       6.565       0.022       0.153       0.004       0.277
PERU             0.154       0.002       2.973                   0.405
PHILIPPINE       1.874       0.054       0.727       0.127       0.419
QATAR            0.851       0.020       0.361                   0.089
RUSSIAN          0.913       0.018       3.124                   0.441
ARABIA           0.892       3.925       2.947       0.004       1.024
SINGAPORE        7.523       0.314       1.992       2.100       0.924
THAILAND         7.622       0.392       2.463       3.201       0.548
US              25.592       4.721      75.203       0.742     354.962
VIETNAM          4.492       0.034       2.397       0.212       0.487
ROW             13.962      29.905     105.676       2.115      15.266

         +       CHILE       CHINA          EU       INDIA   INDONESIA

AUSTRALIA        0.535      41.758      28.449       3.410       3.869
BAHRAIN          0.170       1.554       1.980       0.780       0.137
BRAZIL           5.015      25.898      27.133       3.346       1.894
BRUNEI           0.004       1.464       0.604       0.075       0.123
CANADA           3.081      64.728      50.201       5.382       2.877
CHILE           37.229      13.266       8.262       0.907       0.281
CHINA           51.204    3837.468     219.501      22.025      49.375
EU              19.729     482.438    1988.409      68.609      38.644
INDIA            2.716      60.218      40.520     802.171      21.432
INDONESIA        0.158      31.483       7.229       4.250     484.293
JAPAN           12.925     152.288      61.164       5.909      32.612
KOREA            7.316      87.537      44.407       5.927      14.956
KUWAIT           0.048       4.547       4.705       1.734       0.331
MALAYSIA         0.197      34.295      12.311       6.362      14.261
MEXICO           3.758      94.666      48.939       7.266       3.434
NEWZEALAND       0.140       6.836       4.901       0.493       0.971
PERU             2.178       8.058       3.271       0.885       0.437
PHILIPPINE       0.060      16.634       6.178       1.610       9.546
QATAR            0.020       2.866       8.549       1.786       0.208
RUSSIAN          1.731      42.961      77.031       3.251       2.693
ARABIA           0.244      18.476      27.013       5.785       2.502
SINGAPORE        0.151      41.371      34.053       7.416      20.669
THAILAND         0.698      38.786      12.773       4.626      11.923
US              36.777     853.619     672.741     104.813      53.437
VIETNAM          0.478      49.663      10.332       4.111       5.921
ROW              8.095     805.395    1468.959     243.881      61.571

         +       JAPAN       KOREA      KUWAIT    MALAYSIA      MEXICO

AUSTRALIA        3.472       8.686       0.116       8.566       0.427
BAHRAIN          0.744       0.245       0.355       0.161       0.036
BRAZIL           3.673       4.730       0.608       1.626       1.920
BRUNEI           0.001       0.102                   0.573       0.002
CANADA          16.314       9.544       0.132       3.639       9.182
CHILE            2.135       1.671                   0.267       0.920
CHINA          194.562     229.950      56.089      46.736       4.030
EU              97.218      73.406      15.395      44.574      18.661
INDIA           11.600      15.804      24.453      10.476       0.665
INDONESIA       14.056       7.407       0.707       8.471       0.117
JAPAN          761.981      33.203      24.347      21.373       1.694
KOREA           50.763     189.919      40.275       9.768       1.103
KUWAIT           1.810       1.262      36.405       0.333       0.094
MALAYSIA        14.084       8.987       1.449      19.056       0.172
MEXICO          23.319      22.348       0.074       3.347     112.268
NEWZEALAND       2.716       1.868       0.027       1.630       0.148
PERU             0.955       0.918       0.003       0.267       0.778
PHILIPPINE       9.496       9.989       3.933       4.496       0.067
QATAR            1.145       0.507       0.917       0.336       0.083
RUSSIAN          8.208       6.797                   1.906       0.455
ARABIA           5.142       4.211       1.326       1.380       0.365
SINGAPORE       20.879      13.945      13.001      40.919       1.153
THAILAND        30.962       8.097       2.762      15.550       0.299
US             250.093     136.139      12.340      48.620     307.950
VIETNAM         16.233      46.949       0.936      10.241       0.394
ROW            145.783     112.147      89.749      84.530      30.624

         +  NEWZEALAND        PERU  PHILIPPINE       QATAR     RUSSIAN

AUSTRALIA        8.442       0.386       0.985       1.017       0.170
BAHRAIN          0.084       0.003       0.059                   0.106
BRAZIL           0.088       2.813       0.499       0.806       3.264
BRUNEI           0.009                   0.031       0.011       0.001
CANADA           1.238       2.541       3.073       0.303       1.643
CHILE            0.201       1.825       0.097                   0.070
CHINA           20.347      30.222      20.488      34.333      72.864
EU               8.142      15.524      23.983      35.025     241.800
INDIA            0.997       4.182       1.243      34.301       7.220
INDONESIA        1.076       0.081       1.636       3.863       1.391
JAPAN            4.478       4.484      20.525      51.607      17.741
KOREA            2.183       4.237       5.162      53.044      18.670
KUWAIT           0.100       0.006       0.133       0.154       0.226
MALAYSIA         1.259       0.185       3.773       2.120       1.189
MEXICO           0.635       1.119       1.697       0.265       2.896
NEWZEALAND      35.183       0.064       0.193       0.172       0.170
PERU             0.205      62.415       0.115       0.060       0.455
PHILIPPINE       0.735       0.166     118.104       1.135       1.244
QATAR            0.045       0.110       0.130      95.659       0.268
RUSSIAN          0.215       0.312       0.847       0.117     140.913
ARABIA           0.761       0.019       0.527                   1.316
SINGAPORE        1.297       0.023       8.717      22.394       6.231
THAILAND         1.075       0.218       5.211      10.861       2.413
US              12.738      26.118      39.501       9.718      42.471
VIETNAM          0.820       0.207       2.427       0.464       1.532
ROW             10.916      14.558      47.840      62.411     277.820

         +      ARABIA   SINGAPORE    THAILAND          US     VIETNAM

AUSTRALIA        0.433       6.413      11.797      10.925       2.955
BAHRAIN          7.084       0.092       0.335       0.611       0.147
BRAZIL           2.172       0.484       1.741      13.394       1.581
BRUNEI           0.002       0.335       0.138       0.197       0.016
CANADA           4.098       1.086       4.316     159.703       3.444
CHILE            0.031       0.077       1.058       6.493       0.599
CHINA           54.983      32.219      60.591      91.046      40.609
EU              47.015      24.497      39.455     199.072      48.155
INDIA           29.218      11.863       8.849      16.380       5.511
INDONESIA        4.265      14.887      10.712       4.321       2.515
JAPAN           37.216       8.575      31.091      44.863      17.007
KOREA           27.195       6.584       6.491      29.722      15.436
KUWAIT           1.951       0.115       0.440       1.445       0.413
MALAYSIA         4.409      20.258      13.478       7.798       3.313
MEXICO           0.127       1.900      10.197     150.039       2.613
NEWZEALAND       0.384       1.172       2.149       2.142       0.520
PERU             0.184       0.055       0.454       4.498       0.291
PHILIPPINE       1.751       4.670       8.283       3.741       2.628
QATAR            0.014       0.157       0.380       2.767       0.194
RUSSIAN          0.302       0.718       2.160       6.390       2.072
ARABIA         116.963       1.075       2.342       9.171       1.355
SINGAPORE       13.225       8.456       9.775      21.477       2.975
THAILAND         7.136       6.002      38.550       7.223       4.211
US              46.867      40.918      70.806    2095.007      74.240
VIETNAM          1.395       4.533      12.844       4.851      57.822
ROW            107.116     354.929      67.830     350.614      48.273

         +         ROW

AUSTRALIA       57.561
BAHRAIN          4.754
BRAZIL          50.025
BRUNEI           0.315
CANADA         107.928
CHILE           16.134
CHINA         1238.662
EU            1527.084
INDIA          265.562
INDONESIA       30.715
JAPAN          191.757
KOREA          121.795
KUWAIT          12.325
MALAYSIA        55.291
MEXICO          82.994
NEWZEALAND       7.718
PERU            11.499
PHILIPPINE      16.809
QATAR            2.169
RUSSIAN         59.340
ARABIA          40.435
SINGAPORE      126.682
THAILAND        73.186
US             929.835
VIETNAM         71.886
ROW           1790.167 ;

TABLE PRCT0(R,RR)

             AUSTRALIA     BAHRAIN      BRAZIL      BRUNEI      CANADA

AUSTRALIA        0.912       1.400       1.935       1.054       2.068
BAHRAIN          1.715       0.745       1.775       0.677       2.348
BRAZIL           1.889       1.414       0.935       0.726       1.952
BRUNEI           1.793       1.171       1.470       0.640       1.893
CANADA           1.567       1.453       1.516       0.667       1.204
CHILE            1.651       0.790       1.360       0.678       1.890
CHINA            1.202       1.282       1.319       1.000       1.654
EU               1.399       1.167       1.350       1.319       1.639
INDIA            1.412       1.090       1.484       0.772       1.853
INDONESIA        1.475       1.544       1.752       1.045       2.106
JAPAN            1.258       1.210       1.520       0.975       1.703
KOREA            1.142       1.071       1.302       0.862       1.598
KUWAIT           1.770       1.137       1.671       0.670       2.368
MALAYSIA         1.140       1.108       1.401       0.809       1.721
MEXICO           1.698       1.698       1.443       0.690       1.538
NEWZEALAND       1.186       0.760       2.064       1.038       2.057
PERU             2.190       0.770       1.570       0.661       1.944
PHILIPPINE       1.620       0.792       1.826       1.242       2.056
QATAR            1.550       1.009       1.604       0.671       2.164
RUSSIAN          1.862       0.817       1.652       0.702       2.194
ARABIA           1.761       0.953       1.521       0.677       1.951
SINGAPORE        1.088       1.028       1.405       0.773       1.720
THAILAND         1.052       0.942       1.291       0.775       1.595
US               1.426       1.242       1.359       1.341       1.248
VIETNAM          1.231       0.816       1.435       0.949       1.741
ROW              1.114       0.810       1.105       0.983       1.492

         +       CHILE       CHINA          EU       INDIA   INDONESIA

AUSTRALIA        1.553       1.421       1.689       1.561       1.407
BAHRAIN          0.909       1.857       1.726       1.475       1.803
BRAZIL           1.248       1.522       1.591       1.600       1.630
BRUNEI           1.349       2.030       2.623       1.585       1.698
CANADA           1.346       1.481       1.500       1.552       1.521
CHILE            0.858       1.489       1.632       1.582       1.841
CHINA            1.184       1.079       1.437       1.422       1.271
EU               1.271       1.407       1.102       1.381       1.443
INDIA            1.346       1.521       1.510       1.008       1.271
INDONESIA        1.816       1.576       1.828       1.473       0.870
JAPAN            1.320       1.353       1.566       1.527       1.241
KOREA            1.126       1.229       1.383       1.313       1.139
KUWAIT           0.898       1.645       1.654       1.330       1.603
MALAYSIA         1.414       1.221       1.402       1.208       1.038
MEXICO           1.296       1.594       1.580       1.565       1.738
NEWZEALAND       1.740       1.634       1.772       1.781       1.559
PERU             1.260       1.721       1.869       1.817       2.110
PHILIPPINE       1.839       1.606       1.845       1.788       1.482
QATAR            1.829       1.587       1.494       1.286       1.521
RUSSIAN          1.815       1.520       1.332       1.675       1.657
ARABIA           1.858       1.470       1.500       1.229       1.401
SINGAPORE        1.561       1.219       1.322       1.139       0.952
THAILAND         1.237       1.234       1.315       1.187       1.018
US               1.211       1.386       1.415       1.414       1.426
VIETNAM          1.349       1.252       1.433       1.260       1.219
ROW              1.100       1.856       1.900       1.800       1.324

         +       JAPAN       KOREA      KUWAIT    MALAYSIA      MEXICO

AUSTRALIA        1.428       1.279       1.338       1.199       2.395
BAHRAIN          1.683       1.469       1.053       1.427       2.934
BRAZIL           1.684       1.422       1.232       1.437       1.986
BRUNEI           1.909       1.701       1.084       1.517       2.023
CANADA           1.464       1.355       1.356       1.370       1.643
CHILE            1.593       1.340       0.731       1.580       1.944
CHINA            1.299       1.157       1.052       1.086       1.901
EU               1.472       1.282       1.035       1.220       1.845
INDIA            1.568       1.330       0.910       1.149       1.997
INDONESIA        1.478       1.337       1.271       1.144       2.571
JAPAN            1.036       1.170       0.979       1.127       1.992
KOREA            1.186       1.021       0.836       1.115       1.745
KUWAIT           1.471       1.238       0.690       1.593       1.347
MALAYSIA         1.217       1.086       1.146       0.959       2.027
MEXICO           1.603       1.385       0.744       1.510       1.287
NEWZEALAND       1.622       1.438       0.703       1.277       2.455
PERU             1.840       1.524       0.713       1.846       2.181
PHILIPPINE       1.513       1.332       1.561       1.271       2.421
QATAR            1.318       1.151       1.126       1.303       2.481
RUSSIAN          1.535       1.333       0.757       1.561       2.490
ARABIA           1.401       1.169       1.067       1.362       2.435
SINGAPORE        1.242       1.035       1.250       1.114       1.908
THAILAND         1.179       1.170       1.068       1.069       1.739
US               1.380       1.238       1.038       1.201       1.378
VIETNAM          1.239       1.133       1.208       1.082       2.095
ROW              1.175       1.141       0.816       1.085       1.603

         +  NEWZEALAND        PERU  PHILIPPINE       QATAR     RUSSIAN

AUSTRALIA        1.127       2.028       1.418       1.159       2.019
BAHRAIN          0.918       0.895       0.845       0.923       1.048
BRAZIL           1.915       1.418       1.559       1.170       1.748
BRUNEI           1.682       1.328       1.804       1.072       1.555
CANADA           1.481       1.364       1.363       1.226       1.802
CHILE            1.759       1.241       1.711       1.454       2.092
CHINA            1.313       1.348       1.188       1.003       1.394
EU               1.395       1.433       1.336       0.925       1.196
INDIA            1.532       1.522       1.415       0.870       1.643
INDONESIA        1.554       2.050       1.360       1.193       1.885
JAPAN            1.358       1.501       1.166       0.868       1.466
KOREA            1.221       1.260       1.041       0.789       1.291
KUWAIT           0.908       0.885       1.806       1.114       1.036
MALAYSIA         1.155       1.626       1.058       0.927       1.611
MEXICO           1.655       1.432       1.501       1.315       1.914
NEWZEALAND       0.867       1.846       1.423       1.177       1.926
PERU             1.895       0.845       1.837       0.705       2.152
PHILIPPINE       1.546       1.944       0.798       1.211       2.070
QATAR            1.497       0.886       1.417       0.682       2.209
RUSSIAN          1.689       1.838       1.670       1.523       0.989
ARABIA           1.444       2.128       1.505       0.964       2.007
SINGAPORE        1.123       1.808       0.970       0.763       1.549
THAILAND         1.109       1.329       0.964       0.768       1.398
US               1.404       1.312       1.287       1.051       1.563
VIETNAM          1.277       1.783       1.185       0.995       1.431
ROW              1.141       1.164       1.371       0.824       1.116

         +      ARABIA   SINGAPORE    THAILAND          US     VIETNAM

AUSTRALIA        1.930       1.283       1.108       1.986       1.442
BAHRAIN          1.279       1.486       1.215       2.119       1.226
BRAZIL           1.627       1.618       1.327       1.847       1.640
BRUNEI           1.572       1.752       1.566       3.068       1.925
CANADA           1.620       1.537       1.273       1.428       1.545
CHILE            2.166       1.959       1.386       1.793       1.680
CHINA            1.362       1.216       1.138       1.633       1.240
EU               1.361       1.292       1.147       1.632       1.389
INDIA            1.219       1.275       1.131       1.782       1.336
INDONESIA        1.611       1.179       1.125       2.083       1.497
JAPAN            1.353       1.291       1.094       1.694       1.278
KOREA            1.144       1.306       1.101       1.540       1.292
KUWAIT           1.547       1.952       1.489       1.913       1.871
MALAYSIA         1.420       1.251       1.072       1.591       1.312
MEXICO           1.892       1.597       1.299       1.488       1.740
NEWZEALAND       1.665       1.394       1.229       2.058       1.573
PERU             2.519       2.305       1.512       1.974       2.255
PHILIPPINE       1.886       1.308       1.161       2.050       1.586
QATAR            1.413       1.205       1.082       1.958       1.559
RUSSIAN          2.029       1.686       1.358       2.008       1.546
ARABIA           1.000       1.415       1.274       1.736       1.518
SINGAPORE        1.314       1.077       1.085       1.521       1.078
THAILAND         1.325       1.215       0.961       1.501       1.318
US               1.366       1.289       1.135       1.271       1.389
VIETNAM          1.421       1.194       1.089       1.652       1.069
ROW              1.152       1.258       1.066       1.408       1.746

         +         ROW

AUSTRALIA        1.092
BAHRAIN          1.062
BRAZIL           1.057
BRUNEI           1.659
CANADA           1.108
CHILE            1.146
CHINA            1.091
EU               1.005
INDIA            1.090
INDONESIA        1.361
JAPAN            1.015
KOREA            1.088
KUWAIT           1.058
MALAYSIA         1.011
MEXICO           1.114
NEWZEALAND       1.177
PERU             1.232
PHILIPPINE       1.535
QATAR            1.080
RUSSIAN          1.009
ARABIA           1.030
SINGAPORE        1.045
THAILAND         1.063
US               0.961
VIETNAM          1.461
ROW              0.894 ;

PARAMETER
PRODUCTION(R)     TOTAL PRODUCTION OF TRADABLE GOODS
EXPORT(R)         TOTAL EXPORT OF ONE COUNTRY
IMPORT(R)         TOTAL IMPORT OF ONE COUNTRY
TRADE(R)          TOTAL TRADE OF ONE COUNTRY
UTILITY(R)        TOTAL UTILITY OF ONE COUNTRY
EMPLOYMENT(R)     EXPLOYMENT IN TRADABLE SECTORS
BALANCE(R)        TRADE IMBALANCE
EV(R)             EQUIVALEND VARIATION
CV(R)             COMPENSATION VARIATION

CPRODUCTION       PERCENT CHANGE OF TOTAL PRODUCTION
CEXPORT(R)        PERCENT CHANGE OF TOTAL EXPORT FOR ONE COUNTRY
CIMPORT(R)        PERCENT CHANGE OF TOTAL IMPORT OF ONE COUNTRY
CTRADE(R)         PERCENT CHANGE OF TOTAL TRADE OF ONE COUNTRY
CBALANCE(R)       PERCENT CHANGE OF TRADE IMBALANCE
CUTILITY(R)       PERCENT CHANGE OF UTILITY OF ONE COUNTRY
CEMPLOYMENT(R)    PERCENT CHANGE OF EMPLOYMENT IN TRADABLE SECTOR
EVGDP(R)          EV AS SHARE OF GDP
CVGDP(R)          CV AS SHARE OF GDP

WUTILITY          PERCENT CHANGE OF WORLD UTILITY
WPRODUCTION       PERCENT CHANGE OF WORLD PRODUCTION
WMANUFACTURE      PERCENT CHANGE OF MANUFACTURE SECTOR
WNONMANUFACTURE   PERCENT CHANGE OF NONMANUFACTURE SECTOR
WEMPLOYMENT       PERCENT CHANGE OF WORLD EMPLOYMENT
WTRADE            PERCENT CHANGE OF WORLD TRADE
WEXPORT           PERCENT CHANGE OF WORLD EXPORT
WIMPORT           PERCENT CHANGE OF WORLD IMPORT
;


PRODUCTION(R) = SUM(GG,PRN.L(R,GG)*P.L(R,GG));
EXPORT(R) =  SUM(RR,GDEM.L(RR,R)*P.L(R,"TRADABLE"))-GDEM.L(R,R)*P.L(R,"TRADABLE");
IMPORT(R) =  SUM(RR,GDEM.L(R,RR)*P.L(RR,"TRADABLE"))-GDEM.L(R,R)*P.L(R,"TRADABLE");
TRADE(R) = EXPORT(R)+IMPORT(R);
BALANCE(R) = EXPORT(R)-IMPORT(R);
UTILITY(R) = INC.L(R)*(SHARE1(R)*(PM.L(R)**(1-ELASC1(R)))+SHARE2(R)*(PRCN.L(R)**
(1-ELASC1(R)))) **(1/(ELASC1(R)-1));
EMPLOYMENT(R) = FACDEM.L(R,"TRADABLE","L");
EV(R) = (SUM(RR,GDEM.L(R,RR)*PRCT0(R,RR))+PRCN0(R)*NGDEM.L(R))- (SUM(RR,GDEM0(R,RR)*PRCT0(R,RR))+PRCN0(R)*NGDEM0(R));;
CV(R )= (SUM(RR,GDEM.L(R,RR)*PRCT.L(R,RR))+PRCN.L(R)*NGDEM.L(R))- (SUM(RR,GDEM0(R,RR)*PRCT.L(R,RR))+PRCN.L(R)*NGDEM0(R));

CEXPORT(R) = (EXPORT(R)-EXPORT0(R))*100/EXPORT0(R);
CIMPORT(R) = (IMPORT(R)-IMPORT0(R))*100/IMPORT0(R);
CTRADE(R) = (TRADE(R)-TRADE0(R))*100/TRADE0(R);
CBALANCE(R) = (BALANCE(R)-BALANCE0(R))*100/BALANCE0(R);
CPRODUCTION(R) = (PRODUCTION(R)-PRODUCTION0(R))*100/PRODUCTION0(R);
CUTILITY(R) = (UTILITY(R)-UTILITY0(R))*100/UTILITY0(R);
CEMPLOYMENT(R) = (EMPLOYMENT(R)-EMPLOYMENT0(R))*100/EMPLOYMENT0(R);
EVGDP(R) = EV(R)*100/PRODUCTION(R);
CVGDP(R) = CV(R)*100/PRODUCTION(R);

WUTILITY = (SUM(R,UTILITY(R))-SUM(R,UTILITY0(R)))*100/SUM(R,UTILITY0(R));
WPRODUCTION = (SUM(R,PRODUCTION(R))-SUM(R,PRODUCTION0(R)))*100/SUM(R,PRODUCTION0(R));
WEMPLOYMENT = (SUM(R,EMPLOYMENT(R))-SUM(R,EMPLOYMENT0(R)))*100/SUM(R,EMPLOYMENT0(R));
WTRADE = (SUM(R,TRADE(R))-SUM(R,TRADE0(R)))*100/SUM(R,TRADE0(R));
WEXPORT = (SUM(R,EXPORT(R))-SUM(R,EXPORT0(R)))*100/SUM(R,EXPORT0(R));
WIMPORT = (SUM(R,IMPORT(R))-SUM(R,IMPORT0(R)))*100/SUM(R,IMPORT0(R));


DISPLAY CUTILITY,CPRODUCTION,CEMPLOYMENT,CEXPORT,CIMPORT,CTRADE,CBALANCE,CVGDP,EVGDP
WUTILITY,WPRODUCTION,WEMPLOYMENT,WTRADE,WEXPORT,WIMPORT;
